
Partial Class _Default
    Inherits System.Web.UI.Page

    'constant to set the size of the drawing area
    Const CANVAS_SIZE As Integer = 20
    'constant to set the size of each cell in pixels
    Const CELL_SIZE As Integer = 25
    'constant to set the left indent of the canvas
    Const CANVAS_LEFT As Integer = 30
    'const to set the top indent of the canvas
    Const CANVAS_TOP As Integer = 30
    'constant to set units of measurements for control positioning
    'Const UNITS As String = "px"
    'const to define the prefix for grid cells
    Const IMG_PREFIX As String = "imgCell"
    'const for combo to indicate no library item selected
    Const NO_SCRIPT As String = "(Library)"
    'gpe object
    Dim GPE As New clsGPE(CANVAS_SIZE)

    Protected Sub btnRun_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnRun.Click
        'this event runs when the run script button is pressed
        '
        'clear any existing error messages
        txtError.Text = ""
        'call the run script sub procedure 
        GPE.RunScript(txtScript.Text, "")
        'display the canvas array after the script has been run
        Call DisplayTheCanvas()
        'display the current x position of the pen
        lblX.Text = "X=" & GPE.X
        'display the current y position of the pen
        lblY.Text = "Y=" & GPE.Y
        'display the ink colour
        lblInk.Text = GPE.Ink
        'display any errors
        txtError.Text = GPE.ErrString
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        'this sub runs when the page loads
        'if this is a re load of the page
        If IsPostBack = True Then
            'get the current state of the program
            GPE = Session("GPE")
            'set up the screen
            Call SetUpScreen()
            'display the array containing the canvas
            Call DisplayTheCanvas()
        Else 'if it is the first time the page has loaded
            'initialise the array
            GPE.InitialiseCanvas()
            'set up the screen
            Call SetUpScreen()
            'display the array containing the canvas
            Call DisplayTheCanvas()
            'update the library combo box
            Call DisplayScripts()
        End If
    End Sub

    Protected Sub Page_Unload(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Unload
        'this event runs each time the page unloads
        '
        'store the state of the program
        Session("GPE") = GPE
    End Sub

    Protected Sub cboLibrary_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboLibrary.SelectedIndexChanged
        'this code runs each time the user makes a change to the selection on the drop down list
        '
        Dim Scripts As New clsScripts
        'var to store the name of the script to load
        Dim AScript As String
        'get the system value from the combo
        AScript = cboLibrary.SelectedValue
        'load the script to the interface
        txtScript.Text = Scripts.LoadScript(AScript)
    End Sub

    Sub DisplayScripts()
        Dim Scripts As New clsScripts
        cboLibrary.Items.Clear()
        cboLibrary.Items.Add(NO_SCRIPT)
        cboLibrary.Items.Item(0).Value = ""
        For Counter = 0 To Scripts.Scripts.Count - 1
            cboLibrary.Items.Add(Scripts.Scripts(Counter))
        Next
    End Sub

    Sub DisplayTheCanvas()
        'this sub displays the contents of the array on the screen
        '
        'var for loop
        Dim Count As Integer
        'loop through each element of the array
        For Count = 0 To (CANVAS_SIZE * CANVAS_SIZE) - 1
            'create a new image control
            Dim ImgCell As New Image
            'find the image control on the screen for this array element and make a copy of it
            ImgCell = form1.FindControl(IMG_PREFIX & Count)
            'set the back ground colour to the colour of this array element
            ImgCell.BackColor = GPE.TheCanvas(Count)
            'remove the old image control from the screen
            form1.Controls.Remove(ImgCell)
            'add the new image control
            form1.Controls.Add(ImgCell)
        Next
    End Sub

    Sub SetUpScreen()
        'this sub creates the display area on the page
        '
        'var to store the x position of each cell
        Dim xPosn As Integer
        'var to store the y position of each cell
        Dim yPosn As Integer
        'var to store the id of each control
        Dim Count As Integer
        'start at 0 for control id
        Count = 0
        'loop through y axis
        For yPosn = 0 To CANVAS_SIZE - 1
            'draw the labels for the y axis
            Call PlaceLabel(0 + 0.2, yPosn + 1, yPosn + 1, "y" & Count)
            'loop through x axis
            For xPosn = 0 To CANVAS_SIZE - 1
                'if this is the first column
                If yPosn = 0 Then
                    'draw the x axis labels as well
                    Call PlaceLabel(xPosn + 1, 0, xPosn + 1, "x" & Count)
                End If
                'declare an image control
                Dim ImgCell As New Image
                'set the ID (name) of the control
                ImgCell.ID = IMG_PREFIX & Count
                'set the positioning of the control to absolute
                ImgCell.Style("Position") = "Absolute"
                'set the top position of the control
                ImgCell.Style("Top") = CANVAS_TOP + (CELL_SIZE * yPosn) & "px"
                'set the left position of the control
                ImgCell.Style("Left") = CANVAS_LEFT + (CELL_SIZE * xPosn) & "px"
                'set the image for the cell to blank
                ImgCell.ImageUrl = "blank.gif"
                'add the image control to the page
                form1.Controls.Add(ImgCell)
                'increase the image counter
                Count += 1
            Next
        Next
    End Sub

    Sub PlaceLabel(ByVal xPosn As Integer, ByVal yPosn As Integer, ByVal Label As String, ByVal ID As String)
        'this sub is used to place a lable for either axis
        'it needs the following parameters
        'the x position, the y position, the text of the label and a unique id for the label
        '
        'declare a new label control
        Dim ALabel As New Label
        'set the ID (name)
        ALabel.ID = "lbl" & ID
        'set the position to absolute
        ALabel.Style("Position") = "Absolute"
        'set the top position
        ALabel.Style("Top") = (CANVAS_TOP + 4) + (CELL_SIZE * (yPosn - 1)) & "px"
        'set the left position
        ALabel.Style("Left") = (CANVAS_LEFT + 8) + (CELL_SIZE * (xPosn - 1)) & "px"
        'set the text of the label
        ALabel.Text = Label
        'disable view state
        ALabel.EnableViewState = False
        'add the control to the form
        form1.Controls.Add(ALabel)
    End Sub
End Class
